import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:play_lab/constants/my_strings.dart';
import 'package:play_lab/core/route/route.dart';
import 'package:play_lab/core/utils/dimensions.dart';
import 'package:play_lab/core/utils/my_color.dart';
import 'package:play_lab/data/controller/genres/genres_controller.dart';
import 'package:play_lab/data/repo/genres/genres_repo.dart';
import 'package:play_lab/data/services/api_service.dart';
import 'package:play_lab/view/components/app_bar/custom_appbar.dart';
import 'package:play_lab/view/components/custom_loader/custom_loader.dart';
import 'package:play_lab/view/components/image/my_image_widget.dart';
import 'package:play_lab/view/components/show_more_row/show_more_row.dart';

class GenresScreen extends StatefulWidget {
  const GenresScreen({super.key});

  @override
  State<GenresScreen> createState() => _GenresScreenState();
}

class _GenresScreenState extends State<GenresScreen> {
  @override
  void initState() {
    Get.put(ApiClient(sharedPreferences: Get.find()));
    Get.put(GenresRepo(apiClient: Get.find()));
    final controller = Get.put(GenresController(repo: Get.find()));
    super.initState();
    WidgetsBinding.instance.addPostFrameCallback((t) {
      controller.getDashBoardData();
    });
  }

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: CustomAppBar(title: MyStrings.genres),
      backgroundColor: MyColor.colorBlack,
      body: Padding(
        padding: Dimensions.screenPaddingHV,
        child: GetBuilder<GenresController>(
          builder: (controller) {
            if (controller.isLoading) {
              return CustomLoader();
            }
            return ListView.separated(
              separatorBuilder: (context, index) => SizedBox(height: Dimensions.space20),
              itemCount: controller.genres.length,
              itemBuilder: (context, index) {
                final genres = controller.genres[index];
                return Column(
                  crossAxisAlignment: CrossAxisAlignment.start,
                  children: [
                    ShowMoreText(headerText: genres.name, isShowMoreVisible: false, press: () {}),
                    SizedBox(height: Dimensions.space10),
                    if (genres.items != null && genres.items!.isNotEmpty) ...[
                      SingleChildScrollView(
                        scrollDirection: Axis.horizontal,
                        child: Row(
                          spacing: 20,
                          children: List.generate(genres.items!.length, (index) {
                            final item = genres.items![index];
                            return InkWell(
                              onTap: () => Get.toNamed(RouteHelper.movieDetailsScreen, arguments: [int.parse(item.id ?? "-1"), -1]),
                              child: MyImageWidget(
                                imageUrl: "${controller.landscapePath}${item.image?.landscape}",
                                height: 180,
                                width: 120,
                              ),
                            );
                          }),
                        ),
                      )
                    ] else ...[
                      SizedBox(height: Dimensions.space50),
                    ]
                  ],
                );
              },
            );
          },
        ),
      ),
    );
  }
}
